state BlackFireSpells in W3MagicVigil
{
	var damage_action			 						: W3DamageAction;
	var damage_value									: float;
	var actors 											: array<CActor>;
	var i												: int;
	var main_effect, effect_entity  					: CEntity;
	var target											: CActor; 
	var entities 										: array<CGameplayEntity>; 
	var position 										: Vector;
	var rotation 										: EulerAngles;
	var slotMatrix 										: Matrix;
	var black_trap   									: W3BlackFireTrap;
	var ents_destroy									: array< CEntity >;
	var duration										: float;
	var CustomEffect									: SCustomEffectParams;
	var castDir											: Vector;
	var targetPosition									: Vector;
	var blackball										: W3BlackFireball;
	var boneRotation 									: EulerAngles;
	var bonePosition 									: Vector;
	var dummy											: CEntity;
	var custom_anim										: name;
	var cast_hand										: CEntity;

	event OnEnterState( prevStateName : name )
	{
		if ( !theSound.SoundIsBankLoaded("magic_sorceress.bnk") )
		{
			theSound.SoundLoadBank( "magic_sorceress.bnk", false );
		}
	
		if ( parent.act_signtype == ST_Axii )
		{
			if ( parent.actor && parent.actor.IsAlive() )
			{
				thePlayer.SetSlideTarget( parent.actor );
			}
			else
			{
				thePlayer.AddCustomOrientationTarget( OT_CameraOffset, 'MagicSpells' );
			}
		}
		else
		if ( !theGame.GetInGameConfigWrapper().GetVarValue('magic_spells_main', 'cast_to_camera') )
		{
			if ( !GetMagicVigil().IsAlt() )
			{
				if ( parent.actor && parent.actor.IsAlive() )
				{
					thePlayer.SetSlideTarget( parent.actor );
				}
				else
				{
					thePlayer.AddCustomOrientationTarget( OT_CameraOffset, 'MagicSpells' );
				}
			}
		}
		else
		{
			thePlayer.AddCustomOrientationTarget( OT_CameraOffset, 'MagicSpells' );
		}
		
		if ( parent.alternate )
		{
			//theInput.SetContext('MagicSpellsContext');
			thePlayer.PushState( 'camera_hack' );     
		}
	}
	
	event OnCastSpellAnimation( animEventName : name, animEventType : EAnimationEventType, animInfo : SAnimationEventAnimInfo )
	{
		if ( animEventName == 'cast_begin' )
		{
		}
		else if ( animEventName == 'cast_throw' )
		{
			cast_spells_black();
			thePlayer.RemoveCustomOrientationTarget( 'MagicSpells' );
		}
		else if ( animEventName == 'cast_end' )
		{
			cast_spells_axii_black();
			parent.GotoState( 'Vigil_Dreaming' );
		}
	}
	
	private function cast_spells_black()
	{
		switch( parent.spell_name )
		{
			case 'black_fire_trap':
				{
					theGame.GetEntitiesByTag('black_fire_trap_spells',ents_destroy);
					for( i=0; i<ents_destroy.Size(); i+=1 )
					{
						ents_destroy[i].AddTimer('destroy_black_trap',0.0f);
					} 	
					
					if ( parent.actor && parent.actor.IsAlive() && parent.actor.IsOnGround() && IsRequiredAttitudeBetween(thePlayer, parent.actor, true, false, false)  )
					{
						position = parent.actor.GetWorldPosition();
					}
					else
					{
						position = thePlayer.GetWorldPosition() + thePlayer.GetWorldForward()*3;
						position = find_position_spells( position );
					}
					
					rotation = thePlayer.GetWorldRotation();
					
					duration = 10;
					duration += duration * ( GetMagicVigil().get_magic_spellpower() * 0.5 );
					
					parent.templatename = "dlc\magicspellsrev\data\entities\black_fire_trap.w2ent";
					
					black_trap = (W3BlackFireTrap)theGame.CreateEntity( (CEntityTemplate)LoadResource( parent.templatename ,true ), TraceFloor( position ), rotation );
					black_trap.AddTimer('destroy_black_trap', duration );
					black_trap.AddTag('black_fire_trap_spells');
					black_trap.AddTag( 'spells_from_sign' );
					
					Spells_drain_stamina( parent.stamina_cost, parent.stamina_delay, parent.signskill );
				}

				break;
			case 'black_fire_shield':
				{
					clear_guarding_buffs( false );
				
					CustomEffect.effectType = EET_BlackfireShield;
					CustomEffect.creator = GetWitcherPlayer();
					CustomEffect.duration = CalculateAttributeValue( GetWitcherPlayer().GetSkillAttributeValue( parent.signskill, 'shield_duration', true, true) );
					GetWitcherPlayer().AddEffectCustom( CustomEffect );
					
					Spells_drain_stamina( parent.stamina_cost, parent.stamina_delay, parent.signskill );
				}

				break;
			case 'black_fire_stream':
				{
					parent.templatename = "dlc\magicspellsrev\data\entities\black_fire_amulet.w2ent";
					
					main_effect = (CEntity)theGame.CreateEntity( (CEntityTemplate)LoadResource( parent.templatename ,true ), thePlayer.GetWorldPosition() );
					main_effect.PlayEffect('black_fire_stream');
					main_effect.CreateAttachment( thePlayer, 'l_weapon');
					main_effect.AddTag('spells_alt_stream');
					
					parent.stamina_cost = CalculateAttributeValue( GetWitcherPlayer().GetSkillAttributeValue( parent.signskill, 'stamina_cost_per_sec', false, true ) * 0.5 );
					parent.stamina_cost += parent.stamina_cost * get_stamina_cost_mult_streams(); 
					
					parent.stamina_delay = CalculateAttributeValue( GetWitcherPlayer().GetSkillAttributeValue( parent.signskill, 'stamina_delay', false, true ) );
					parent.stamina_delay += parent.stamina_delay * get_stamina_delay_mult(); 
					
					register_cancel_input_spells();
					
					cast_spells_stream_black();
				}

				break;
			case 'black_fire_cone':
				{
					thePlayer.CalcEntitySlotMatrix('l_weapon', slotMatrix);
					position = MatrixGetTranslation(slotMatrix);
					rotation = MatrixGetRotation(slotMatrix);
						
					rotation.Roll = ClampF(rotation.Roll,-100,10);
					
					parent.templatename = "dlc\magicspellsrev\data\entities\black_fire_amulet.w2ent";
					
					main_effect = (CEntity)theGame.CreateEntity( (CEntityTemplate)LoadResource( parent.templatename ,true ), position, rotation );
					main_effect.PlayEffect('black_fire_cone');
					main_effect.DestroyAfter(10);
					
					actors = thePlayer.GetNPCsAndPlayersInCone(5, VecHeading(thePlayer.GetHeadingVector()), 80, 20, , FLAG_Attitude_Hostile + FLAG_OnlyAliveActors);
					
					for( i = 0; i < actors.Size(); i += 1 )
					{
						target = (CActor)actors[i];
						
						damage_value = get_damage_value_for_cone( target, GetMagicVigil().get_magic_spellpower() );
						
						damage_action =  new W3DamageAction in this;
						damage_action.Initialize(thePlayer,target,this,thePlayer.GetName()+"_sign",EHRT_None,CPS_Undefined,false, false, true, false );
						damage_action.SetProcessBuffsIfNoDamage(true);
						damage_action.SetHitReactionType(EHRT_Heavy);
						damage_action.SetHitEffect('');
						damage_action.SetHitEffect('', true );
						damage_action.SetHitEffect('', false, true);
						damage_action.SetHitEffect('', true, true);
						damage_action.SetHitAnimationPlayType(EAHA_Default);
						
						damage_action.AddDamage( theGame.params.DAMAGE_NAME_FIRE, sp_fire_dmg_mod() * damage_value * 0.5 );
						damage_action.AddDamage( theGame.params.DAMAGE_NAME_ELEMENTAL, sp_elem_dmg_mod() * damage_value * 0.5 );
						damage_action.AddEffectInfo( EET_SpellsSlowDownAverage, MaxF( 3, MinF( 8, GetMagicVigil().get_magic_spellpower() *3 ) ) );
						
						effect_entity = target.CreateFXEntityAtPelvis( 'black_fire_effects', true );
						effect_entity.PlayEffect( 'black_flame' );
						effect_entity.DestroyAfter(5);
						
						if ( spells_can_dismember( target ) )
						{
							damage_action.SetForceExplosionDismemberment();
						}
						
						theGame.damageMgr.ProcessAction( damage_action );
						delete damage_action;
					}
					
					Spells_drain_stamina( parent.stamina_cost, parent.stamina_delay, parent.signskill );
				}
				
				break;
			default:		
				break;
		}
	}
	
	private function cast_spells_axii_black()
	{
		var vector_attach 				: Vector;
	
		if ( parent.spell_name == 'black_fire_projectile' )
		{
			if ( parent.actor && parent.actor.IsAlive() && IsRequiredAttitudeBetween(thePlayer, parent.actor, true, false, false) )
			{
				targetPosition = parent.actor.GetBoneWorldPosition( spells_get_pelvis_name( parent.actor ) );
				targetPosition.Z += 0.3;
			
				parent.templatename = "dlc\magicspellsrev\data\entities\black_fire_projectile.w2ent";

				vector_attach = Vector( -0.2, 0.07, 0.05 );

				blackball = (W3BlackFireball)theGame.CreateEntity( (CEntityTemplate)LoadResource( parent.templatename, true ), thePlayer.GetWorldPosition() );
				blackball.CreateAttachment( thePlayer, 'l_weapon', vector_attach );
				blackball.AddTag( 'spells_custom_projs' );
				blackball.AddTag( 'spells_from_sign' );
				blackball.Init(NULL);
				blackball.PlayEffect( 'venom' );
				blackball.BreakAttachment();
				blackball.ShootProjectileAtPosition(0, 15, targetPosition );
				blackball.DestroyAfter(10);

				effect_entity = (CEntity)theGame.CreateEntity( (CEntityTemplate)LoadResource( 'black_fire_effects' ), thePlayer.GetWorldPosition() ) ;
				effect_entity.CreateAttachment( thePlayer, 'l_weapon', vector_attach );
				effect_entity.PlayEffect( 'black_fireball_shot' );
				effect_entity.DestroyAfter(3);
				
				Spells_drain_stamina( parent.stamina_cost, parent.stamina_delay, parent.signskill );
				
				thePlayer.SetCombatIdleStance( 1.f );
			}
		}
	}
	
	private entry function cast_spells_stream_black()
	{
		var damage_action_stream				: W3DamageAction;
		var victims 							: array<CActor>;
		var victim								: CActor;
		var damage 								: float;
		var channelDmg 							: SAbilityAttributeValue;
		var i									: int;
		var castDir								: Vector;
		var targetPosition						: Vector;
		var position							: Vector;
		var slotMatrix 							: Matrix;
		var effectentity						: CEntity;
		var coll, normal 						: Vector;
		var lastpos 							: Vector;
		
		while ( true )
		{
			if (  thePlayer.GetStatPercents( BCS_Stamina ) > 0.01f && thePlayer.GetBehaviorVariable	( 'IsCastingSign' ) == 1 )
			{
				thePlayer.CalcEntitySlotMatrix('l_weapon', slotMatrix);
				position = MatrixGetTranslation(slotMatrix);
				
				castDir 		= MatrixGetAxisX( thePlayer.GetBoneWorldMatrixByIndex( thePlayer.GetBoneIndex( 'l_weapon' ) ) );
				targetPosition  = position + ( 6 * castDir );
				
				parent.hand_aim_position = position;
				parent.hand_aim_direction = castDir;
			
				victims = thePlayer.GetNPCsAndPlayersInCone( 6, VecHeading( castDir ), 25, 20, , FLAG_Attitude_Hostile + FLAG_OnlyAliveActors);
				for (i=0; i<victims.Size(); i+=1)			
				{
					victim = (CActor)victims[i];
					if ( GetAttitudeBetween( victim, thePlayer ) == AIA_Hostile && victim.IsAlive() )
					{
						damage = get_damage_value_for_stream( victim, GetMagicVigil().get_magic_spellpower() );
						damage *= theTimer.timeDelta;
					
						damage_action_stream = new W3DamageAction in this;
						damage_action_stream.Initialize(thePlayer,victim,this,thePlayer.GetName()+"_sign",EHRT_None,CPS_SpellPower,false, false, true, false );
						damage_action_stream.SetProcessBuffsIfNoDamage(true);
						
						damage_action_stream.AddDamage( theGame.params.DAMAGE_NAME_FIRE, sp_fire_dmg_mod() * damage * 0.5 );
						damage_action_stream.AddDamage( theGame.params.DAMAGE_NAME_ELEMENTAL, sp_elem_dmg_mod() * damage * 0.5 );
						damage_action_stream.AddEffectInfo(EET_SpellsSlowDownAverage, MaxF( 3, MinF( 8, parent.spellpower_final * 3 ) ) );
						
						damage_action_stream.SetIsDoTDamage( theTimer.timeDelta );
							
						damage_action_stream.SetHitAnimationPlayType(EAHA_ForceNo);
						damage_action_stream.SetHitEffect('');
						damage_action_stream.SetHitEffect('', true );
						damage_action_stream.SetHitEffect('', false, true);
						damage_action_stream.SetHitEffect('', true, true);
						
						if ( ( (CNewNPC)victim ).IsShielded( thePlayer ) )
						{
							if ( ( (CNewNPC)victim ).GetBehaviorVariable( 'bShieldUp' ) == 0.f )
							{
								( (CNewNPC)victim ).SetBehaviorVariable( 'bShieldUp', 1.f );
							}
							
							if ( ( (CNewNPC)victim ).GetStaminaPercents() > 0.1 )
							{
								( (CNewNPC)victim ).DrainStamina(ESAT_FixedValue, 3 );
							}
							else 
							{
								( (CNewNPC)victim ).ProcessShieldDestruction();
							}
						}
						else
						{
							if( RandF()<0.1 ) 
							{ 
								damage_action_stream.AddEffectInfo( EET_SpellsSlowDownCritical, 1 ); 
							}
						}
						
						if ( spells_can_dismember( victim ) )
						{
							damage_action_stream.SetForceExplosionDismemberment();
						}
						
						theGame.damageMgr.ProcessAction( damage_action_stream );
						delete damage_action_stream;
					}
				}
				
				if( theGame.GetWorld().SweepTest( position + castDir, targetPosition, 0.3, coll, normal, parent.collisions_stream ) )
				{
					lastpos = coll;
					theGame.GetEntityByTag( 'spells_stream_collision' ).PlayEffectSingle('collision_fx');
				}
				else
				{
					theGame.GetEntityByTag( 'spells_stream_collision' ).StopAllEffects();
				}
				
				if ( !theGame.GetEntityByTag( 'spells_stream_collision' ) )
				{
					effectentity = theGame.CreateEntity( (CEntityTemplate)LoadResource("dlc\magicspellsrev\data\entities\black_fire_stream_collision.w2ent",true), targetPosition, thePlayer.GetWorldRotation() );
					effectentity.AddTag('spells_stream_collision');
				}
				else
				{
					theGame.GetEntityByTag( 'spells_stream_collision' ).Teleport(lastpos);
				}
				
				GetWitcherPlayer().DrainStamina( ESAT_FixedValue, parent.stamina_cost * theTimer.timeDelta, parent.stamina_delay ); 
			}
			else
			{
				thePlayer.SoundEvent("gui_no_stamina");
				parent.PushState('Vigil_Dreaming');
			}
			
			Sleep( theTimer.timeDelta );
		}
	
	}
	
	event OnLeaveState( nextStateName : name )
	{
	}
}